<?php 
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class ApprovazioneFile {
        private $db;
        private $id;
        private $nome;
        private $cartellaDaApprovare;
        private $destinatari;
        private $testo;
        private $termineApprovazione;
        private $testoTermineScaduto;
        
        public function __construct($db, $id, $nome="", $cartellaDaApprovare=0, $destinatari="", $testo="", $termineApprovazione="", $testoTermineScaduto="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->cartellaDaApprovare = $cartellaDaApprovare;
            $this->destinatari         = $destinatari;
            $this->testo               = $testo;
            $this->termineApprovazione = $termineApprovazione;
            $this->testoTermineScaduto = $testoTermineScaduto;
        }

        function crea() {
            $query    = "INSERT INTO `geec_approvazioniFile` (`id`, `nome`, `cartellaDaApprovare`, `destinatari`, `testo`, `termineApprovazione`,`testoTermineScaduto`) 
                            VALUES (NULL, '$this->nome', '$this->cartellaDaApprovare', '$this->destinatari', '$this->testo', '$this->termineApprovazione','$this->testoTermineScaduto');";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE `geec_approvazioniFile` SET nome = '$this->nome', cartellaDaApprovare = '$this->cartellaDaApprovare',  destinatari = '$this->destinatari', testo = '$this->testo', termineApprovazione='$this->termineApprovazione', testoTermineScaduto='$this->testoTermineScaduto' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_approvazioniFile",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 19
            eliminaOccorrenzeComponente($this->db,$this->id,26);
        }
        
        function caricaDatiDalDatabase() {
            $datiCondivisione      = $this->db->leggiSingolaRiga("geec_approvazioniFile",$this->id);
            $this->nome            = $datiCondivisione["nome"];
            $this->cartellaDaApprovare  = $datiCondivisione["cartellaDaApprovare"];
            $this->destinatari            = $datiCondivisione["destinatari"];
            $this->testo                  = $datiCondivisione["testo"];
            $this->termineApprovazione    = $datiCondivisione["termineApprovazione"];
            $this->testoTermineScaduto    = $datiCondivisione["testoTermineScaduto"];
        }
        
        function duplica($prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_approvazioniFile WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_approvazioniFile SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_approvazioniFile SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        /*
         * Getter & setter
         */
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getCartellaDaApprovare() {
            return $this->cartellaDaApprovare;
        }

        public function getDestinatari() {
            return $this->destinatari;
        }

        public function getTesto() {
            return $this->testo;
        }

        public function getTermineApprovazione() {
            return $this->termineApprovazione;
        }

        public function getTestoTermineScaduto() {
            return $this->testoTermineScaduto;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setCartellaDaApprovare($cartellaDaApprovare): void {
            $this->cartellaDaApprovare = $cartellaDaApprovare;
        }

        public function setDestinatari($destinatari): void {
            $this->destinatari = $destinatari;
        }

        public function setTesto($testo): void {
            $this->testo = $testo;
        }

        public function setTermineApprovazione($termineApprovazione): void {
            $this->termineApprovazione = $termineApprovazione;
        }

        public function setTestoTermineScaduto($testoTermineScaduto): void {
            $this->testoTermineScaduto = $testoTermineScaduto;
        }
    }